'use strict';

/* --------------------------------------------------------------
 forgot_password.js 2021-01-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2021 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gambio.widgets.module('forgot_password', [], function (data) {

    'use strict';

    var $this = $(this),
        defaults = {},
        options = $.extend(true, {}, defaults, data),
        module = {};

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {
        var _$this$data = $this.data(),
            minPasswordLength = _$this$data.minPasswordLength;

        var passwordChange = function passwordChange() {
            var newPassword = document.getElementById('newPassword'),
                confirmedPassword = document.getElementById('confirmedPassword'),
                submitButton = document.getElementById('submit-button'),
                passwordLengthElement = document.getElementById('password-length'),
                passwordValidationElement = document.getElementById('password-validation');

            var hasMinimumLength = newPassword.value.length >= minPasswordLength,
                isConfirmed = newPassword.value === confirmedPassword.value;

            if (!hasMinimumLength) {
                passwordLengthElement.classList.remove('hidden');
                submitButton.disabled = true;
            } else if (hasMinimumLength) {
                passwordLengthElement.classList.add('hidden');
            }

            if (!isConfirmed) {
                if (confirmedPassword.value.length > 0) {
                    passwordValidationElement.classList.remove('hidden');
                }
                submitButton.disabled = true;
            } else if (isConfirmed) {
                passwordValidationElement.classList.add('hidden');
            }

            if (hasMinimumLength && isConfirmed) {
                submitButton.disabled = false;
            }
        };

        document.getElementById('newPassword').addEventListener('input', passwordChange);
        document.getElementById('confirmedPassword').addEventListener('input', passwordChange);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndpZGdldHMvZm9yZ290X3Bhc3N3b3JkLmpzIl0sIm5hbWVzIjpbImdhbWJpbyIsIndpZGdldHMiLCJtb2R1bGUiLCJkYXRhIiwiJHRoaXMiLCIkIiwiZGVmYXVsdHMiLCJvcHRpb25zIiwiZXh0ZW5kIiwiaW5pdCIsImRvbmUiLCJtaW5QYXNzd29yZExlbmd0aCIsInBhc3N3b3JkQ2hhbmdlIiwibmV3UGFzc3dvcmQiLCJkb2N1bWVudCIsImdldEVsZW1lbnRCeUlkIiwiY29uZmlybWVkUGFzc3dvcmQiLCJzdWJtaXRCdXR0b24iLCJwYXNzd29yZExlbmd0aEVsZW1lbnQiLCJwYXNzd29yZFZhbGlkYXRpb25FbGVtZW50IiwiaGFzTWluaW11bUxlbmd0aCIsInZhbHVlIiwibGVuZ3RoIiwiaXNDb25maXJtZWQiLCJjbGFzc0xpc3QiLCJyZW1vdmUiLCJkaXNhYmxlZCIsImFkZCIsImFkZEV2ZW50TGlzdGVuZXIiXSwibWFwcGluZ3MiOiI7O0FBQUE7Ozs7Ozs7Ozs7QUFVQUEsT0FBT0MsT0FBUCxDQUFlQyxNQUFmLENBQXNCLGlCQUF0QixFQUF5QyxFQUF6QyxFQUE2QyxVQUFVQyxJQUFWLEVBQWdCOztBQUV6RDs7QUFFQSxRQUFJQyxRQUFRQyxFQUFFLElBQUYsQ0FBWjtBQUFBLFFBQ0lDLFdBQVcsRUFEZjtBQUFBLFFBRUlDLFVBQVVGLEVBQUVHLE1BQUYsQ0FBUyxJQUFULEVBQWUsRUFBZixFQUFtQkYsUUFBbkIsRUFBNkJILElBQTdCLENBRmQ7QUFBQSxRQUdJRCxTQUFTLEVBSGI7O0FBS0E7Ozs7QUFJQUEsV0FBT08sSUFBUCxHQUFjLFVBQVVDLElBQVYsRUFBZ0I7QUFBQSwwQkFDSU4sTUFBTUQsSUFBTixFQURKO0FBQUEsWUFDbEJRLGlCQURrQixlQUNsQkEsaUJBRGtCOztBQUcxQixZQUFNQyxpQkFBaUIsU0FBakJBLGNBQWlCLEdBQU07QUFDekIsZ0JBQU1DLGNBQWNDLFNBQVNDLGNBQVQsQ0FBd0IsYUFBeEIsQ0FBcEI7QUFBQSxnQkFDSUMsb0JBQW9CRixTQUFTQyxjQUFULENBQXdCLG1CQUF4QixDQUR4QjtBQUFBLGdCQUVJRSxlQUFlSCxTQUFTQyxjQUFULENBQXdCLGVBQXhCLENBRm5CO0FBQUEsZ0JBR0lHLHdCQUF3QkosU0FBU0MsY0FBVCxDQUF3QixpQkFBeEIsQ0FINUI7QUFBQSxnQkFJSUksNEJBQTRCTCxTQUFTQyxjQUFULENBQXdCLHFCQUF4QixDQUpoQzs7QUFNQSxnQkFBTUssbUJBQW1CUCxZQUFZUSxLQUFaLENBQWtCQyxNQUFsQixJQUE0QlgsaUJBQXJEO0FBQUEsZ0JBQ0lZLGNBQWNWLFlBQVlRLEtBQVosS0FBc0JMLGtCQUFrQkssS0FEMUQ7O0FBR0EsZ0JBQUksQ0FBQ0QsZ0JBQUwsRUFBdUI7QUFDbkJGLHNDQUFzQk0sU0FBdEIsQ0FBZ0NDLE1BQWhDLENBQXVDLFFBQXZDO0FBQ0FSLDZCQUFhUyxRQUFiLEdBQXdCLElBQXhCO0FBQ0gsYUFIRCxNQUdPLElBQUlOLGdCQUFKLEVBQXNCO0FBQ3pCRixzQ0FBc0JNLFNBQXRCLENBQWdDRyxHQUFoQyxDQUFvQyxRQUFwQztBQUNIOztBQUVELGdCQUFJLENBQUNKLFdBQUwsRUFBa0I7QUFDZCxvQkFBSVAsa0JBQWtCSyxLQUFsQixDQUF3QkMsTUFBeEIsR0FBaUMsQ0FBckMsRUFBeUM7QUFDckNILDhDQUEwQkssU0FBMUIsQ0FBb0NDLE1BQXBDLENBQTJDLFFBQTNDO0FBQ0g7QUFDRFIsNkJBQWFTLFFBQWIsR0FBd0IsSUFBeEI7QUFDSCxhQUxELE1BS08sSUFBSUgsV0FBSixFQUFpQjtBQUNwQkosMENBQTBCSyxTQUExQixDQUFvQ0csR0FBcEMsQ0FBd0MsUUFBeEM7QUFDSDs7QUFFRCxnQkFBSVAsb0JBQW9CRyxXQUF4QixFQUFxQztBQUNqQ04sNkJBQWFTLFFBQWIsR0FBd0IsS0FBeEI7QUFDSDtBQUNKLFNBN0JEOztBQStCQVosaUJBQVNDLGNBQVQsQ0FBd0IsYUFBeEIsRUFBdUNhLGdCQUF2QyxDQUF3RCxPQUF4RCxFQUFpRWhCLGNBQWpFO0FBQ0FFLGlCQUFTQyxjQUFULENBQXdCLG1CQUF4QixFQUE2Q2EsZ0JBQTdDLENBQThELE9BQTlELEVBQXVFaEIsY0FBdkU7O0FBRUFGO0FBQ0gsS0F0Q0Q7O0FBd0NBLFdBQU9SLE1BQVA7QUFDSCxDQXRERCIsImZpbGUiOiJ3aWRnZXRzL2ZvcmdvdF9wYXNzd29yZC5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tXG4gZm9yZ290X3Bhc3N3b3JkLmpzIDIwMjEtMDEtMjBcbiBHYW1iaW8gR21iSFxuIGh0dHA6Ly93d3cuZ2FtYmlvLmRlXG4gQ29weXJpZ2h0IChjKSAyMDIxIEdhbWJpbyBHbWJIXG4gUmVsZWFzZWQgdW5kZXIgdGhlIEdOVSBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIChWZXJzaW9uIDIpXG4gW2h0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy9ncGwtMi4wLmh0bWxdXG4gLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbiAqL1xuXG5nYW1iaW8ud2lkZ2V0cy5tb2R1bGUoJ2ZvcmdvdF9wYXNzd29yZCcsIFtdLCBmdW5jdGlvbiAoZGF0YSkge1xuXG4gICAgJ3VzZSBzdHJpY3QnO1xuXG4gICAgbGV0ICR0aGlzID0gJCh0aGlzKSxcbiAgICAgICAgZGVmYXVsdHMgPSB7fSxcbiAgICAgICAgb3B0aW9ucyA9ICQuZXh0ZW5kKHRydWUsIHt9LCBkZWZhdWx0cywgZGF0YSksXG4gICAgICAgIG1vZHVsZSA9IHt9O1xuXG4gICAgLyoqXG4gICAgICogSW5pdCBmdW5jdGlvbiBvZiB0aGUgd2lkZ2V0XG4gICAgICogQGNvbnN0cnVjdG9yXG4gICAgICovXG4gICAgbW9kdWxlLmluaXQgPSBmdW5jdGlvbiAoZG9uZSkge1xuICAgICAgICBjb25zdCB7IG1pblBhc3N3b3JkTGVuZ3RoIH0gPSAkdGhpcy5kYXRhKCk7XG5cbiAgICAgICAgY29uc3QgcGFzc3dvcmRDaGFuZ2UgPSAoKSA9PiB7XG4gICAgICAgICAgICBjb25zdCBuZXdQYXNzd29yZCA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCduZXdQYXNzd29yZCcpLFxuICAgICAgICAgICAgICAgIGNvbmZpcm1lZFBhc3N3b3JkID0gZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoJ2NvbmZpcm1lZFBhc3N3b3JkJyksXG4gICAgICAgICAgICAgICAgc3VibWl0QnV0dG9uID0gZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoJ3N1Ym1pdC1idXR0b24nKSxcbiAgICAgICAgICAgICAgICBwYXNzd29yZExlbmd0aEVsZW1lbnQgPSBkb2N1bWVudC5nZXRFbGVtZW50QnlJZCgncGFzc3dvcmQtbGVuZ3RoJyksXG4gICAgICAgICAgICAgICAgcGFzc3dvcmRWYWxpZGF0aW9uRWxlbWVudCA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCdwYXNzd29yZC12YWxpZGF0aW9uJyk7XG5cbiAgICAgICAgICAgIGNvbnN0IGhhc01pbmltdW1MZW5ndGggPSBuZXdQYXNzd29yZC52YWx1ZS5sZW5ndGggPj0gbWluUGFzc3dvcmRMZW5ndGgsXG4gICAgICAgICAgICAgICAgaXNDb25maXJtZWQgPSBuZXdQYXNzd29yZC52YWx1ZSA9PT0gY29uZmlybWVkUGFzc3dvcmQudmFsdWU7XG5cbiAgICAgICAgICAgIGlmICghaGFzTWluaW11bUxlbmd0aCkge1xuICAgICAgICAgICAgICAgIHBhc3N3b3JkTGVuZ3RoRWxlbWVudC5jbGFzc0xpc3QucmVtb3ZlKCdoaWRkZW4nKTtcbiAgICAgICAgICAgICAgICBzdWJtaXRCdXR0b24uZGlzYWJsZWQgPSB0cnVlO1xuICAgICAgICAgICAgfSBlbHNlIGlmIChoYXNNaW5pbXVtTGVuZ3RoKSB7XG4gICAgICAgICAgICAgICAgcGFzc3dvcmRMZW5ndGhFbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2hpZGRlbicpO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBpZiAoIWlzQ29uZmlybWVkKSB7XG4gICAgICAgICAgICAgICAgaWYgKGNvbmZpcm1lZFBhc3N3b3JkLnZhbHVlLmxlbmd0aCA+IDAgKSB7XG4gICAgICAgICAgICAgICAgICAgIHBhc3N3b3JkVmFsaWRhdGlvbkVsZW1lbnQuY2xhc3NMaXN0LnJlbW92ZSgnaGlkZGVuJyk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIHN1Ym1pdEJ1dHRvbi5kaXNhYmxlZCA9IHRydWU7XG4gICAgICAgICAgICB9IGVsc2UgaWYgKGlzQ29uZmlybWVkKSB7XG4gICAgICAgICAgICAgICAgcGFzc3dvcmRWYWxpZGF0aW9uRWxlbWVudC5jbGFzc0xpc3QuYWRkKCdoaWRkZW4nKTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgaWYgKGhhc01pbmltdW1MZW5ndGggJiYgaXNDb25maXJtZWQpIHtcbiAgICAgICAgICAgICAgICBzdWJtaXRCdXR0b24uZGlzYWJsZWQgPSBmYWxzZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCduZXdQYXNzd29yZCcpLmFkZEV2ZW50TGlzdGVuZXIoJ2lucHV0JywgcGFzc3dvcmRDaGFuZ2UpO1xuICAgICAgICBkb2N1bWVudC5nZXRFbGVtZW50QnlJZCgnY29uZmlybWVkUGFzc3dvcmQnKS5hZGRFdmVudExpc3RlbmVyKCdpbnB1dCcsIHBhc3N3b3JkQ2hhbmdlKTtcblxuICAgICAgICBkb25lKCk7XG4gICAgfTtcblxuICAgIHJldHVybiBtb2R1bGU7XG59KTtcbiJdfQ==
